import os
import sys
sys.path.append(os.path.dirname(os.path.realpath(__file__)))

import paho.mqtt.client as mqtt
import ssl
import time
import logging
import configparser
import platform
from flufl.i18n import initialize
from mqtt_manager import mqtt_manager
from device_manager import device_manager
from database_manager import database_manager
from random import random
from kivy.app import App
from kivy.uix.image import Image
from kivy.uix.widget import Widget
from kivy.uix.button import Button
from kivy.uix.togglebutton import ToggleButton
from kivy.graphics import Color, Ellipse, Line
from kivy.lang import Builder
from kivy.resources import resource_add_path
from kivy.uix.screenmanager import ScreenManager, Screen, FadeTransition, NoTransition
from kivy.gesture import Gesture, GestureDatabase
from kivy.clock import Clock
from kivy.config import Config
from kivy.properties import ObjectProperty, StringProperty, NumericProperty
from functools import partial
from subprocess import call
from __version__ import __version__
from screens import SostenibileBoxApp, BaseScreen, SplashScreen, ConfigScreen, CameraScreen

_ = initialize('flufl')

def main():
    """Entry point for the application script"""
    must_exit = False
    try:
        import config

        if platform.machine().startswith('arm') and config.mode == 'production':
            ini = configparser.ConfigParser()
            ini.read('/root/.kivy/config.ini')
            mouse = r'mouse'
            if os.path.exists('/dev/input/ts_uinput'):
                mtdev = r'mtdev,/dev/input/ts_uinput'
            else:
                mtdev = r'probesysfs,provider=mtdev'
            hid = r'probesysfs,provider=hidinput'
            if 'input' not in ini or 'mouse' not in ini['input'] or ini['input']['mouse'] != mouse or r'mtdev_%(name)s' not in ini['input'] or ini['input'][r'mtdev_%(name)s'] != mtdev or r'hid_%(name)s' not in ini['input'] or ini['input'][r'hid_%(name)s'] != hid:
                ini['input']['mouse'] = mouse
                ini['input'][r'mtdev_%(name)s'] = mtdev
                ini['input'][r'hid_%(name)s'] = hid
                with open('/root/.kivy/config.ini', 'w') as configfile:
                    ini.write(configfile)
                must_exit = True
    except:
        pass

    if must_exit:
        sys.exit(0)

    logger = logging.getLogger('root')
    Config.set('kivy', 'keyboard_mode', 'systemanddock')
    logger.info('Avvio applicazione box ' + __version__)

    db = database_manager()
    mqtt = mqtt_manager()
    mqtt.connect()
    device = device_manager()
    device.connect()

    resource_add_path(os.path.abspath(os.path.join(os.path.dirname(__file__), 'ui')))
    Config.set('kivy', 'default_font', [
        'Roboto',
        'Roboto-Regular.ttf',
        'Roboto-Italic.ttf',
        'Roboto-Bold.ttf',
        'Roboto-BoldItalic.ttf',
    ])    
    Builder.load_file('screenmanager.kv')

    SostenibileBoxApp().run()

    logger.info('Fine applicazione box')

    mqtt.disconnect()
