import logging
from singleton import Singleton
import platform
import sqlite3
try:
    import RPi.GPIO as GPIO
    import serial
except ImportError:
    pass

class database_manager(Singleton):
    logger = None

    def __init__(self):
        self.logger = logging.getLogger('root')
        if platform.machine().startswith('arm'):
            self.conn = sqlite3.connect("/root/box.db")
        else:
            self.conn = sqlite3.connect("box.db")
        self.conn.isolation_level = None
        self.conn.row_factory = sqlite3.Row
        c = self.conn.cursor()
        c.execute("CREATE TABLE IF NOT EXISTS boxes ("
                  "addr INTEGER NOT NULL,"
                  "version INTEGER NOT NULL DEFAULT 0,"
                  "doors INTEGER NOT NULL DEFAULT 1,"
                  "type_ref VARCHAR NOT NULL DEFAULT 'C',"
                  "min_temp INTEGER NOT NULL DEFAULT 0,"
                  "max_temp INTEGER NOT NULL DEFAULT 100,"
                  "uv_present INTEGER NOT NULL DEFAULT 0,"
                  "led_present INTEGER NOT NULL DEFAULT 0,"
                  "door_status INTEGER NOT NULL DEFAULT 0,"
                  "temperature INTEGER NOT NULL DEFAULT 0,"
                  "door_fault INTEGER NOT NULL DEFAULT 0,"
                  "temp_fault INTEGER NOT NULL DEFAULT 0,"
                  "other_fault INTEGER NOT NULL DEFAULT 0,"
                  "PRIMARY KEY(addr))")
        c.close()

    def get_conn(self):
        return self.conn

    def get_boxes_db(self, addr = None):
        c = self.conn.cursor()
        c.execute("SELECT * FROM boxes {}".format("ORDER BY addr" if addr is None else "WHERE addr = {}".format(addr)))
        boxes = c.fetchall()
        boxes_db = {}
        for box in boxes:
            boxes_db[box['addr']] = dict(box)
        c.close()
        return boxes_db
