import paho.mqtt.client as mqtt
import ssl
import time
import json
import sys
import os.path
import traceback
import logging
import subprocess
import platform
from database_manager import database_manager
from singleton import Singleton
from __version__ import __version__


class mqtt_logging_handler(logging.Handler):
    client = None

    def emit(self, record):
        import config
        try:
            msg = self.format(record)
            self.client.publish("box/" + config.mqtt_auth['client_id'] + "/log", msg, qos=0)
        except (KeyboardInterrupt, SystemExit):
            raise
        except:
            self.handleError(record)


class mqtt_manager(Singleton):
    client = None
    logger = None

    def on_connect(self, client, userdata, flags, rc):
        import config
        self.logger.debug("Flag connessione: " + str(flags) + " codice risultato: " + str(rc) + " client id: " + str(client._client_id))
        self.client.subscribe("server/box/" + config.mqtt_auth['client_id'] + "/#", qos=0)
        # Sottoscriviamo i broadcast a qos 1
        self.client.subscribe("server/box/broadcast/#", qos=1)
        self.client.publish("box/" + config.mqtt_auth['client_id'] + "/online", "1", qos=0, retain=False)

    def on_message(self, client, userdata, msg):
        import config
        self.logger.debug("Ricevuto messaggio. Topic: " + msg.topic + " - qos: " + str(msg.qos) + " - payload: " + str(msg.payload.decode("utf-8")))
        try:
            if msg.topic.startswith("server/box/broadcast/"):
                # TODO: Rimuovere questo comando che puo' creare gravi problemi di sicurezza
                #if msg.topic.endswith("/exec"):
                #    output = subprocess.check_output(msg.payload.decode("utf-8"), stderr=subprocess.STDOUT, shell=True)
                #    self.logger.debug("Output comando: " + output)
                if msg.topic.endswith("/sw_ver"):
                    current_version = __version__.split(".")
                    str_available_version = msg.payload.decode("utf-8")
                    available_version = str_available_version.split(".")
                    if int(available_version[0]) * 100000000L + int(available_version[1]) * 10000L + int(available_version[2]) > int(current_version[0]) * 100000000L + int(current_version[1]) * 10000L + int(current_version[2]):
                        self.logger.debug("Nuova versione software disponibile: " + str_available_version)
                        if platform.machine().startswith('arm'):
                            try:
                                output = subprocess.check_output("cd /boot && sudo bash install.sh && sudo shutdown -r", stderr=subprocess.STDOUT, shell=True)
                            except subprocess.CalledProcessError as exc:
                                self.logger.error(e)
                                output = e.output
                            self.logger.info("Output comando aggiornamento: " + str(output))
        except Exception as e:
            self.logger.error(e)
        except:
            e = sys.exc_info()[0]
            self.logger.error(e)

    def __init__(self):
        import config
        self.client = mqtt.Client(config.mqtt_auth['client_id'])
        self.client.on_connect = self.on_connect
        self.client.on_message = self.on_message
        self.client.username_pw_set(config.mqtt_auth['username'], config.mqtt_auth['password'])
        self.client.tls_set(ca_certs="sos_mqtt_ca.crt", tls_version=ssl.PROTOCOL_TLSv1_2)
        # install handler for exceptions
        sys.excepthook = self.handle_exception
        # configure logging via MQTT
        self.logger = logging.getLogger('root')
        self.logger.setLevel(logging.DEBUG)

        formatter = logging.Formatter(fmt='%(asctime)s - %(levelname)s - %(module)s.%(funcName)s:%(lineno)d - %(message)s')
        handler = logging.StreamHandler()
        handler.setFormatter(formatter)
        handler.setLevel(logging.DEBUG)
        self.logger.addHandler(handler)
        
        formatter = logging.Formatter(fmt='%(asctime)s|--|%(levelname)s|--|%(module)s.%(funcName)s:%(lineno)d|--|%(message)s')
        handler = mqtt_logging_handler()
        handler.setFormatter(formatter)
        handler.setLevel(logging.INFO)
        handler.client = self.client
        self.logger.addHandler(handler)

    def connect(self):
        import config
        self.client.will_set("box/" + config.mqtt_auth['client_id'] + "/online", "0", qos=0, retain=False)
        self.client.connect_async(host="mqtt.sostenibile.com", port=8883)
        self.client.loop_start()

    def send_status(self):
        import config
        from __version__ import __version__
        db = database_manager()
        boxes_db = {'boxes': db.get_boxes_db(), 'app_ver':__version__}
        self.client.publish("box/" + config.mqtt_auth['client_id'] + "/status", json.dumps(boxes_db), qos=0, retain=False)

    def disconnect(self):
        import config
        self.client.publish("box/" + config.mqtt_auth['client_id'] + "/online", "0", qos=0, retain=False)
        time.sleep(2)
        self.client.disconnect()
        self.client.loop_stop()

    def handle_exception(self, exc_type, exc_value, exc_traceback):
        """ handle all exceptions """

        ## KeyboardInterrupt is a special case.
        ## We don't raise the error dialog when it occurs.
        #if issubclass(exc_type, KeyboardInterrupt):
        #    sys.exit(1)

        filename, line, dummy, dummy = traceback.extract_tb( exc_traceback ).pop()
        filename = os.path.basename( filename )
        error    = "%s: %s" % ( exc_type.__name__, exc_value )

        self.logger.critical("".join(traceback.format_exception(exc_type, exc_value, exc_traceback)))
        self.disconnect()
        sys.exit(1)
